%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% EJAM.cls, v0.1, 2023/05/03
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\ProvidesClass{LAMP}[2023/05/03, v0.1]
\LoadClass[twoside,11pt]{article}
\RequirePackage[utf8]{inputenc}
\RequirePackage{microtype}
% \RequirePackage{mathpazo}
\RequirePackage[square,numbers,sort&compress]{natbib} %
\setlength{\bibsep}{2px}
\def\bibfont{\footnotesize}
\RequirePackage{relsize}
\RequirePackage{ragged2e}
\RequirePackage{xcolor}
\RequirePackage{colortbl}
\RequirePackage{graphicx}
\RequirePackage{etoolbox,xpatch}
\RequirePackage{environ}
\RequirePackage{lastpage}
\RequirePackage{rotating}
% \RequirePackage{afterpage}
\RequirePackage[absolute]{textpos}
\RequirePackage{newfloat}
\RequirePackage{titlesec}
\RequirePackage{scrextend}
\RequirePackage{calc}
\RequirePackage{geometry}
\geometry{a4paper,
  includefoot,
  hmargin=5.5pc+6.64pt,
  bottom=3pc+10pt,
  top=7pc+6pt,
  headsep=1pc,
  headheight=17.5pt,
  footnotesep=1pc+6pt,
  columnsep=18pt
}

% \setlength{\parindentpt}

\RequirePackage[noblocks]{authblk}
\renewcommand*{\Authsep}{, }
\renewcommand*{\Authand}{, }
\renewcommand*{\Authands}{, }
\RequirePackage[export]{adjustbox}
\RequirePackage{siunitx}
\def\@jlogo{lapm_theme/LAPM_logo.pdf}

% \newcommand{\jname}[1]{\def\@jname{#1}}
% \newcommand{\jlogo}[1]{\def\@jlogo{#1}}

\def\@jyear{20xx}
\def\@jvolume{0}
\def\@jnumber{0}
\def\@jstartpage{1}
\def\@jendpage{1}
\def\@jdoi{}
\def\@runningtitle{}
\def\@jname{Electronic Journal of Applied Mathematics}
\def\@papercat{}
\def\@runningauthor{}
\def\@runningtitle{}
\def\@corraddress{}
\def\@authnotes{}

\newcommand{\jdoi}[1]{\def\@jdoi{#1}}
\newcommand{\jyear}[1]{\def\@jyear{#1}}
\newcommand{\jvolume}[1]{\def\@jvolume{#1}}
\newcommand{\jnumber}[1]{\def\@jnumber{#1}}
\newcommand{\jstartpage}[1]{\def\@jstartpage{#1}}
\newcommand{\jendpage}[1]{\def\@jendpage{#1}}
\newcommand{\jname}[1]{\def\@jname{#1}}
\newcommand{\runningauthor}[1]{\def\@runningauthor{#1}}
\newcommand{\runningtitle}[1]{\def\@runningtitle{#1}}
\newcommand{\corraddress}[1]{\def\@corraddress{#1}}
\newcommand{\authnote}[1]{\appto{\@authnotes}{#1\par}}
\newcommand{\papercat}[1]{\def\@papercat{#1}}

\setlength{\parskip}{3pt plus 1pt}

\colorlet{jcolour}{blue!40}
\definecolor{email_color}{HTML}{1793c6}
\definecolor{Org}{HTML}{073453}

\RequirePackage{fontawesome}
\newcommand\Email[1]{\href{mailto:#1}{\textsuperscript{\textcolor{email_color}\faEnvelope{ }}}}


\RequirePackage[pdftex,
  pdfauthor={\@runningauthor},
  pdftitle={\@runningtitle},
  pdfsubject={The Subject},
  % pdfkeywords={Some Keywords},
  pdfproducer={Mersin University},
  pdfcreator={Latex},
  colorlinks, 
  citecolor=newblue,
  linkcolor=newblue,
  urlcolor=newblue]{hyperref}




\definecolor{jcolour}{RGB}{0,0,0}
\definecolor{newblue}{HTML}{007377}


\RequirePackage[flushmargin,bottom]{footmisc}
\appto{\footnotelayout}{\fontsize{6.5pt}{9.5pt}\selectfont}
\deffootnote{1.5em}{1.5em}{\thefootnotemark\enspace}

\RequirePackage{fancyhdr}
\fancyhf{}
\renewcommand{\headrulewidth}{.4pt}
% \renewcommand{\headrule}{\color{black!100}\rule{\textwidth}{1pt}}

% \fancyhead[LO,RE]{%
%   \hspace*{12pt}%
%   \fontsize{10pt}{11pt}\selectfont%
%   \color{jcolour}%
%   \textbf{\thepage}%
%   \hspace{1em}\raisebox{-0.5pt}{$ |$}\hspace{1em}%
%   \textit{\@jname}, \@jyear, Vol.~\@jvolume, No.~\@jnumber
% }
% \fancyhead[RO,LE]{%
%   \fontsize{10pt}{11pt}\selectfont%
%   \color{jcolour}%
%   \@runningauthor%
%   \hspace{1em}\raisebox{-0.5pt}{$|$}\hspace{1em}%
%   \textbf{\thepage}%
%   \hspace*{12pt}%
% }

\fancyhead[RO]{
  \fontsize{9pt}{10pt}\selectfont
  \emph{\@runningauthor} \hspace{1em}\raisebox{-1.5pt}{$|$}\hspace{1em} \fontsize{10pt}{15pt}\selectfont\textbf{\thepage}
}

\fancyhead[LO]{
  \fontsize{9pt}{10pt}\selectfont
  \emph{\@runningtitle}
}

\fancyhead[LE]{
  \fontsize{9pt}{10pt}\selectfont
  \textbf{\thepage} \hspace{1em}\raisebox{-1.5pt}{$|$}\hspace{1em}  \fontsize{10pt}{15pt}\selectfont {Lett. Appl. Pure Math.}
}

\fancyhead[RE]{
  \fontsize{10pt}{11pt}\selectfont
  {\@jyear, Vol.~\@jvolume, No.~\@jnumber}
}


\fancypagestyle{plain}{%
  \fancyhf{}
  \renewcommand{\headrule}{}
  \fancyfoot[C]{%
    % \fontsize{9pt}{10pt}\selectfont%
    \color{jcolour}%
    \fontsize{10pt}{11pt}\selectfont
    \textbf{\thepage}
  }
}

\pagestyle{fancy}


\AtBeginDocument{% 
  \setcounter{page}{\@jstartpage}
  \newsavebox{\@gscitedetails}
  \newlength{\@gscitedetailsheight}
  \newsavebox{\@gsheadbox}
  \newlength{\@gsheadboxheight}
  \savebox{\@gscitedetails}{%
    \parbox{\textwidth-12cm}{%
      \raggedleft{\bfseries{Research article}}  \par
      % \normalfont{\itshape\bfseries\@jname}, \@jyear, \@jstartpage--\pageref{LastPage}\par
      \vspace{\dimexpr 20pt-1em\relax}
      % {\color{black!40}\rule{\linewidth}{3pt}}
      \par%
      \vspace{\dimexpr 10pt-1em\relax}% 
      \fontsize{8pt}{11pt}\bfseries% 
      \vspace{\dimexpr 10pt-1em\relax}
      ISSN: 2980-1982\\
      \textcolor{jcolour}{\@jyear, Vol.~\@jvolume, No.~\@jnumber}, \@jstartpage--\hypersetup{linkcolor=black}\pageref{LastPage}\par
      \fontsize{8pt}{11pt}\bfseries%
      % DOI: \@jdoi\par
      \vspace{\dimexpr 8pt-1em\relax}%
      % {\color{black!40}\rule{\linewidth}{3pt}}\par
    }}%
  \settototalheight{\@gscitedetailsheight}{\usebox{\@gscitedetails}}%
  %%%%
  \savebox{\@gsheadbox}{%
    \parbox{\textwidth-21pc+4pc+6.64pt}{%
      \normalfont%
      \fontsize{8pt}{9.5pt}\selectfont%
      % {\itshape\bfseries\@jname}, \@jyear, \@jstartpage--\pageref{LastPage}\par
      \vspace{\dimexpr 8pt-1.5pt\relax}%
      \usebox{\@gscitedetails}
    }%
  }%
  \settototalheight{\@gsheadboxheight}{\usebox{\@gsheadbox}}%
}

\RequirePackage{alphalph}
\newalphalph{\fnsymbolmult}[mult]{\@fnsymbol}{5}

\newcounter{authorfn}
\setcounter{authorfn}{1}
\newcommand{\authfn}[1]{%
  \fnsymbolmult{#1}%
}


\renewcommand\Authands{ and } 
\renewcommand\AB@affilsepx{ \authorcr }
% \renewcommand{\Authfont}{\fontsize{11pt}{18pt}\selectfont}
\renewcommand{\Affilfont}{\fontsize{9pt}{13pt}\selectfont}
\renewcommand\AB@affilnote[1]{{\fontsize{9pt}{13pt}\selectfont{#1. }}}
\setlength{\affilsep}{21pt-9pt}


\AtBeginDocument{
  \renewcommand{\@maketitle}{%
    \textblockorigin{4pc+6.64pt}{4pc+6pt}
    %%%%

    % \begin{textblock*}{20pc}(0pt,0pt)
    %   \begin{minipage}[b][\@gsheadboxheight]{\@gsheadboxheight}
    %     \mbox{}\includegraphics[height=1.5cm]{\@jlogo}
    %   \end{minipage}
    % \end{textblock*}

    %%%

    \begin{textblock*}{\textwidth-21pc}(28.5pc,0pt)
      \usebox{\@gsheadbox}
    \end{textblock*}% 


    \vspace*{\dimexpr 36pt-3pt-1em\relax}
    % {\noindent\color{jcolour!100}\rule{\hsize}{1pt}}\par

   \noindent \makebox[\textwidth]{\includegraphics[width = 21cm]{lapm_theme/LAPM_logo}}

     %%%  Title of paper
    \null\vspace*{\dimexpr 4pc+11pt-5pc-6pt\relax}%
    \raggedright%
    {\fontsize{14pt}{16pt}\selectfont%
      \ifpdf
        \textls[200]{\relsize{-1}\MakeUppercase{\@papercat}}
      \else %%% don't use letterspace in latex+dvi
        \relsize{-1}\MakeUppercase{\@papercat}%
      \fi%
      \par}
    \vspace{\dimexpr 26pt-18pt\relax}
    {\fontsize{18pt}{22pt}\bfseries\color{jcolour}\@title\par}
    \vspace{\dimexpr 26pt-13pt\relax}
    \@author\par
    \vspace{\dimexpr 15.5pt-1em}
    {%
      \renewcommand{\authfn}[1]{%
        \textsuperscript{\fnsymbolmult{##1}}%
      }
      {\fontsize{9pt}{11pt}\selectfont\@authnotes\par}%
    }
    \vspace{\dimexpr 2pc+ 16pt-3pt-1em\relax}
  }
}




\RequirePackage[style]{abstract}
\setlength{\absleftindent}{0pt}
\setlength{\absrightindent}{0pt}
% \setlength{\absparindent}{12pt}
% \setlength{\absparsep}{0pt}
\setlength{\abstitleskip}{15pt-8pt-\baselineskip}
\renewcommand{\abstractnamefont}{\fontsize{12pt}{16pt}\bfseries\color{jcolour}}
\renewcommand{\abstitlestyle}[1]{\noindent{\abstractnamefont #1}}
% \renewcommand{\abstracttextfont}{\fontsize{11pt}{13pt}\selectfont}
\preto{\abstract}{%
  {\noindent\color{Org}\rule{\hsize}{2pt}}\par
  \vspace*{\dimexpr 15pt-10pt\relax}
}
\appto\abstract{\noindent\ignorespaces}
% \preto\endabstract{\par}

\newenvironment{keywords}
{\justifying\vspace*{\dimexpr 20pt-8pt-\baselineskip\relax}%
  \noindent\fontsize{9pt}{10pt}\selectfont\textbf{Keywords:} \ignorespaces}%
{\par\vspace{6pt}}
\newenvironment{classifications}
{\justifying\vspace*{\dimexpr 15pt-8pt-\baselineskip\relax}%
  \noindent\fontsize{9pt}{10pt}\selectfont\textbf{MSC (2020):} \ignorespaces}%
{\par\vspace{6pt}}

\newenvironment{history}
{\justifying\vspace*{\dimexpr 15pt-8pt-\baselineskip\relax}%
  \noindent\fontsize{9pt}{10pt}\selectfont\textbf{Article history:} \ignorespaces}%
{\par\vspace{0pt}}

\DeclareFloatingEnvironment[placement=t!,name=kpt]{keypoints}

\xapptocmd{\keypoints}{%
  \begin{mdframed}[linewidth=1pt,linecolor=black,
      innerleftmargin=8pt,innerrightmargin=8pt,
      innertopmargin=16pt-8.2pt,innerbottommargin=6pt]
    {\fontsize{8.2pt}{10pt}\bfseries Key Points\par}
    }{}{}
    \xpretocmd{\endkeypoints}{\end{mdframed}}{}{}

\xapptocmd{\keypoints*}{%
  \begin{mdframed}[linewidth=1pt,linecolor=black,
      innerleftmargin=8pt,innerrightmargin=8pt,
      innertopmargin=16pt-8.2pt,innerbottommargin=6pt]
    {\fontsize{8.2pt}{10pt}\bfseries Key Points\par}
    }{}{}
    \xpretocmd{\endkeypoints*}{\end{mdframed}}{}{}

\newcommand{\authorEmail}[1]{\def\@authorEmail{#1}}

\NewEnviron{frontmatter}{%
  \BODY%
  \vspace*{\dimexpr 13pt-3pt-1em\relax}
  {\noindent\color{Org}\rule{\hsize}{2pt}}\par
  \vspace*{\dimexpr 23pt-1em\relax}%
  \begin{figure*}[b!]
    % \fontsize{9pt}{11pt}\selectfont%
    {\color{Org}\rule{2cm}{2pt}} \par
    \raggedright \fontsize{9pt}{10pt}\selectfont
    %  \@authorEmail
    \vspace{.1cm} \color{black!80}
    \copyright~\@jyear~ The Author(s). 
This is an Open Access article distributed under the terms of the \href{https://creativecommons.org/licenses/by/4.0/}{Creative Commons Attribution 4.0 International License}, which permits unrestricted use, distribution, and reproduction in any medium, provided the original author and source
are credited.
  \end{figure*}
}

% \setcounter{secnumdepth}{0}
\titleformat*{\section}{\fontsize{12pt}{14pt}\bfseries\color{jcolour}}
\titlespacing*{\section}{0pt}{26.5pt-1em}{16pt-1em}
\titleformat*{\subsection}{\fontsize{11pt}{13pt}\bfseries\color{jcolour}}
\titlespacing*{\subsection}{0pt}{2pc-1em}{17pt-1em}
\titleformat*{\subsubsection}{\normalsize\bfseries\slshape}
\titlespacing*{\subsubsection}{0pt}{\baselineskip}{0pt}
\titleformat{\paragraph}[runin]{\normalsize\itshape}{\theparagraph}{0pt}{}[.\enspace]
% \titlespacing*{\paragraph}{0pt}{\baselineskip}{0pt}
%   \titleformat{\subparagraph}[runin]{\relsize{-1}\uppercase}{\thesubparagraph}{0pt}{}[.\enspace]
% \titlespacing*{\subparagraph}{0pt}{\baselineskip}{0pt}

\RequirePackage{enumitem}
\setlist{noitemsep}
\setlist[itemize]{leftmargin=24pt,topsep=16pt-1em}
\setlist[enumerate]
{itemindent=14pt,topsep=16.8pt-1em,
  label={\roman*.},labelsep=7pt,
  labelwidth=*,leftmargin=*,align=right}


% quotes and epigraphs
\RequirePackage{quoting}
\newcommand{\quotefont}{\fontsize{9pt}{11pt}\selectfont}
\quotingsetup{vskip=16pt-1em,indentfirst=false,font={quotefont},leftmargin=12pt,rightmargin=12pt}

\renewenvironment{quote}{\begin{quoting}}{\end{quoting}}

\renewenvironment{quotation}{\begin{quoting}}{\end{quoting}}

\newenvironment{epigraph}[1]
{\begin{quoting}[font={itshape,fontsize{7.5pt}{10.5pt}},vskip=15pt-1em,leftmargin=0pt,rightmargin=0pt]%
    \def\@quotesource{#1}}
    {\par\vspace{\dimexpr 15pt-1em\relax}{\upshape---\@quotesource}\end{quoting}}


\RequirePackage{stfloats}
\RequirePackage{booktabs}
\RequirePackage{tabularx}
% Left-, right- and center-aligned auto-wrapping column types
\newcolumntype{L}{>{\raggedright\arraybackslash}X}
\newcolumntype{R}{>{\raggedleft\arraybackslash}X}
\newcolumntype{C}{>{\centering\arraybackslash}X}

\AtBeginEnvironment{tabularx}{%
  \fontsize{9pt}{11pt}\selectfont
}
\AtBeginEnvironment{tabular}{%
  \fontsize{9pt}{11pt}\selectfont
}

% \setlength{\aboverulesep}{11pt-1em}
% \setlength{\belowrulesep}{11pt-1em}
% \setlength{\heavyrulewidth}{0.5pt}
% \setlength{\lightrulewidth}{0.5pt}
% \arrayrulecolor{jcolour}


% \newcommand{\tnote}[1]{\textsuperscript{\textit{#1}}}
% \newlist{tablenotes}{itemize}{1}
% \setlist[tablenotes]{label={},labelsep=0pt,leftmargin=0pt,topsep={\dimexpr 12pt-1em\relax}}
% \appto{\tablenotes}{\fontsize{9pt}{11pt}\selectfont}

\RequirePackage[font=small,labelfont=bf,tableposition=top]{caption}
\setlength{\abovecaptionskip}{5pt plus 2pt minus 2pt}
% \DeclareCaptionFont{figcaptionfont}{\fontsize{9pt}{11pt}\selectfont}
% \DeclareCaptionFont{tabcaptionfont}{\fontsize{9pt}{11pt}\selectfont}
% \captionsetup{justification=justified,singlelinecheck=false,labelfont={bf},labelsep=period}
% \captionsetup*[figure]{font=figcaptionfont,skip=10pt}
% \captionsetup*[table]{font=tabcaptionfont,skip=10pt-1em}

% Skips for floats
% \setlength{\floatsep}{1pc+6pt}
% \setlength{\intextsep}{1pc+6pt}
% \setlength{\textfloatsep}{1pc+6pt}

%% References
%\if@numrefs
%  \RequirePackage[numbers]{natbib}
%  \bibliographystyle{vancouver-authoryear}
%\fi
%\if@alpharefs
%    \RequirePackage{natbib}
%    \bibliographystyle{dcu}
%\fi
%\setlength{\bibhang}{11pt}
%\setlength{\bibsep}{0pt}
%\renewcommand{\bibnumfmt}[1]{#1.}

% \RequirePackage{natbib}
